/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;

import lotus.domino.*;
import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;


/**
 * @author  Thomas Ekert
 */
public class DJStressTest implements Runnable{

	private boolean done=false;
	private int delay_count=0;
	private String title="new Thread";
	private String pwd="geheim";
	private String host="";
	private String user="";

	public void run () {
		Session session = null;
		Database db = null;
		CMSDocument doc=null, nextDoc=null;
		View view=null;
		DocumentCollection dc=null;
		try {
			System.out.println ("Running Thread " + title);
			session=NotesFactory.createSession (host, user, pwd);
			db = session.getDatabase(session.getServerName(),"djbuch/djbuch.nsf");
			String key = "Document in Thread " + title;
			doc = CMSDocument.getInstance (DemoTools.createDoc(db,"Wombat",key,null));
			GC.recycle(doc);doc=null;
			view = db.getView("V_lookup_k6");
			dc=view.getAllDocumentsByKey(key,true);
			doc=CMSDocument.getInstance (dc.getFirstDocument());
			while (doc!=null) {
				nextDoc = CMSDocument.getInstance(dc.getNextDocument());
				doc.setActive(doc.isActive()?false:true);
				doc.save(true,false);
				GC.recycle(doc);
				doc=nextDoc;
			}
		} catch (NotesException e) {
			System.out.println ("id = " + (e instanceof NotesException?""+((NotesException)e).id:""));
			e.printStackTrace();
		} finally {
			done=true;
			GC.recycle(doc);
			GC.recycle(nextDoc);
			GC.recycle(dc);
			GC.recycle(view);
			GC.recycle(db);
			GC.recycle(session);
		}		
	}
	
	public boolean isDone() {
		return done;
	}
	
	public DJStressTest (String t, String h, String u, String pass) {
		this.title=t;
		this.pwd=pass;
		this.host=h;
		this.user=u;
	}
}
